## MongoDB 数据同步

**1. 背景**

在 PB 级数据同步的场景下，需要一个高效、可靠的机制将 MongoDB 中的数据同步到其他系统。`consistent_sql` 组件旨在提供这样的能力，确保数据在同步过程中的一致性和完整性。

**2. 遇到的难点**

*   **大规模数据处理**：如何高效处理和传输 PB 级别的海量数据。
*   **断点续传**：在同步过程中发生中断（如网络问题、服务重启）后，如何从断点处精确恢复，避免数据丢失或重复。
*   **增量同步**：如何持续捕获 MongoDB 中的数据变更，并实时同步到目标系统。
*   **异构数据源兼容**：如何设计一套通用的同步机制，能够适配包括 MongoDB 在内的多种数据源。

**3. 解决方案与实现的功能**

*   **流式处理与数据分块 (`use_stream_mode`, `chunk_size`)**：
    *   将大规模数据切分为可管理的小块（例如默认 256MB）进行流式处理，避免一次性加载过多数据导致内存溢出。
*   **并行传输 (`parallel_streams`)**：
    *   支持配置多个并行数据流，提升数据同步的吞吐量。
*   **基于 GTID (ObjectID) 的断点续传 (`gtid`, `LastID`)**：
    *   **GTID 机制**：使用 MongoDB 的 `ObjectID` 作为全局事务 ID (GTID)。`ObjectID` 天然具有顺序性，可以精确标记同步的断点。
    *   **断点记忆**：`syncMongoTask` 函数在同步过程中，会记录最后成功处理的文档的 `ObjectID` (`LastID`)。当任务重启或中断后恢复时，会从这个 `LastID` 之后开始查询数据 (`_id > lastID`)，确保不漏数据也不重传数据。
    *   **检查点 (`saveCheckpoint()`)**：定期保存包含 `LastID` 的检查点信息，用于故障恢复。
*   **增量同步与持续监听**：
    *   `syncMongoTask` 在同步完当前所有数据后并不会立即退出，而是会持续监听新的数据变更。当没有新数据时，会清理资源并等待一段时间后再次查询，以捕获后续的增删改操作。
*   **消息确认机制 (`FirstSend`, `WaitingAck`, `MRsprowmsg`)**：
    *   为了保证数据按顺序被目标端成功处理，引入了消息确认机制。
    *   首次发送数据时不等待确认，以尽快开始数据传输。
    *   后续发送数据后，会等待目标端的确认消息 (`MRsprowmsg`)，收到确认后才继续发送下一批数据。这确保了数据的可靠投递。
*   **统一的数据发送格式 (`sendSyncResult()`)**：
    *   将 MongoDB 的数据（文档）封装成统一的二进制消息格式发送给目标端。
    *   消息中包含 GTID (`ObjectID`)、数据库名、集合名、操作类型（插入、更新、删除）以及实际的数据内容（通常包含 `_id`, `data`, `optype` 三列）。
    *   这种统一格式方便了客户端处理来自不同数据源的数据。
*   **错误处理与重试**：
    *   在数据发送等关键步骤加入了错误重试机制，提高同步的健壮性。
*   **可配置的任务参数**：
    *   用户可以通过 JSON 配置创建同步任务，指定 MongoDB 连接信息、数据库、集合、起始 `gtid` (ObjectID)、查询条件 (`mongo_query`)、批处理大小 (`mongo_batch_size`) 等。

**总结：MongoDB 数据同步功能通过利用 ObjectID 作为 GTID，结合流式处理、并行传输、消息确认和检查点机制，实现了对大规模数据的可靠、高效、持续的增量同步，并保证了数据的最终一致性。**

## Elasticsearch 数据同步

**1. 背景**

与 MongoDB 类似，在需要将 Elasticsearch 中的大规模数据同步到其他系统的场景下，`consistent_sql` 组件提供了相应的解决方案，以保证数据同步的效率和可靠性。

**2. 遇到的难点**

*   **大规模索引的遍历**：如何高效遍历 Elasticsearch 中的大量文档。
*   **断点续传与状态保持**：如何在长时间的同步任务中，尤其是在使用 Scroll API 时，有效记录和恢复同步状态。
*   **实时性要求**：如何捕获 Elasticsearch 中接近实时的数据变更。
*   **与不同数据源的统一处理**：如何将 Elasticsearch 的同步逻辑融入通用的同步框架中。

**3. 解决方案与实现的功能**

*   **流式处理与 Scroll API (`es_scroll_time`, `es_batch_size`)**：
    *   利用 Elasticsearch 的 Scroll API 高效地拉取大量数据。用户可以配置 `scroll` 的保持时间和每批获取的文档数量。
*   **并行传输与数据分块 (PB级同步可选参数 `parallel_streams`, `chunk_size`)**：
    *   与 MongoDB 类似，支持并行处理和数据分块，以提升大规模数据同步的性能。
*   **基于 GTID (文档ID) 和 Scroll 状态的断点续传 (`gtid`, `LastScrollID`, `LastTimestamp`)**：
    *   **GTID 机制**：使用 Elasticsearch 文档的 `_id` 作为 GTID 的一部分或起始点。
    *   **断点记忆**：`syncESTask` 函数不仅依赖于文档 ID，还利用 `LastScrollID` (最后一次 scroll 请求的 ID) 和 `LastTimestamp` (可能用于增量拉取新数据的时间戳) 来共同维护断点状态。
    *   **检查点 (`saveCheckpoint()`)**：定期保存包含这些状态信息的检查点。
*   **增量同步与持续监听**：
    *   `syncESTask` 在同步完当前查询结果后，会持续监听新的数据。文档中提到“同步到最后一条数据后不退出，持续监听新数据”。这可能通过定期执行新的查询或利用 Elasticsearch 的某些特性来实现。
*   **消息确认机制 (`FirstSend`, `WaitingAck`, `MRsprowmsg`)**：
    *   与 MongoDB 同步采用完全相同的消息确认机制，确保数据按序、可靠地被目标端处理。
*   **统一的数据发送格式 (`sendSyncResult()`)**：
    *   将 Elasticsearch 的文档数据封装成与 MongoDB 同步时一致的二进制消息格式。
    *   消息中包含 GTID (文档 `_id`)、数据库名 (固定为 "elasticsearch")、索引名、操作类型以及实际的文档内容。
    *   这使得客户端可以用同样的方式处理来自 ES 的数据。
*   **错误处理与重试**：
    *   内置错误重试机制，增强同步的稳定性。
*   **可配置的任务参数**：
    *   用户可以通过 JSON 配置创建同步任务，指定 ES 连接信息、索引名、文档类型、起始 `gtid` (文档ID)、查询DSL (`es_query`)、scroll 参数等。
*   **优化的 ES HTTP 客户端 (`getESClient()`)**：
    *   维护连接池，重用 HTTP 客户端，并优化连接参数，以提高与 Elasticsearch 通信的性能。

**总结：Elasticsearch 数据同步功能通过结合 Scroll API、文档 ID 作为 GTID，以及与 MongoDB 类似的流式处理、并行传输、消息确认和检查点机制，实现了对大规模索引数据的高效、可靠和持续的同步，并确保了与整体框架的一致性。**
